/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#pragma once

#include "IPAddress.h"

#include <chrono>
#include <cstdint>
#include <functional>
#include <string>

class RpcClientEvent;

enum class LogLevel
{
	Off = 0,
	Critical = 1,
	Error = 2,
	Information = 3,
	Verbose = 4
};

class RpcClientConfiguration
{
private:
	static const std::uint32_t DefaultBufferSize;
	static const std::uint32_t DefaultReceiveTimeoutMs;

public:
	static const char LogFileName[];
	IPAddress Address = IPAddressIPv4Loopback;
	std::int32_t Port = 49374;

	bool EnableLogging = false;
	std::int32_t TruncateArgumentLength = -1;
	std::string LogDir;
	std::uint32_t ReceiveBufferSize = DefaultBufferSize;
	std::chrono::milliseconds ReceiveTimeoutMs;
	std::function<void(const RpcClientEvent&)> NotificationEvent;
};
